<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExchangeFee extends Model 
{

    protected $table = 'exchange_fees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('default', 'currency_in_id', 'slug', 'my_anount_buy', 'inter_amount_buy', 'nat_amount_buy', 'my_anount_sell', 'nat_amount_sell', 'inter_amount_sell', 'status');
    protected $visible = array('default', 'currency_in_id', 'currency_out_id', 'slug', 'my_anount_buy', 'inter_amount_buy', 'nat_amount_buy', 'my_anount_sell', 'nat_amount_sell', 'inter_amount_sell', 'status');

    public function currencyIn()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_in_id');
    }

    public function exchanges()
    {
        return $this->hasMany('App\Models\Exchange', 'exchange_fee_id');
    }

    public function currencyOut()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_out_id');
    }

}